//+------------------------------------------------------------------+
//|                              ARROW_RSI_CROSS50.mq4                                                             
//+------------------------------------------------------------------+
#property copyright "AHGduP"
#property link      "ARROW_RSI_CROSS-70"

#property indicator_chart_window
//#include <WinUser32.mqh>
#property indicator_buffers 2
#property indicator_color1 Lime //LimeGreen
#property indicator_width1 2
#property indicator_color2 Yellow//Yellow
#property indicator_width2 2

//====================================================

extern int        TF               = 0 ;

extern string     RSI              = "== RSI ===";           
extern int        RSIPeriod        = 14 ; //14

//====================================================

extern bool   Alarm_On       =  True ; 
//extern int    LineSize       = 2 ;//2
extern int    Move_Arrow     = 10 ;
extern int    CountBars      = 1000 ;//500    

bool   StepTF_Up   =  true; 

double RSI1_up , RSI1_dn ; 

double up1, down1 ;

double bBuffer1[];
double sBuffer1[];
double alertBar;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_ARROW);//LineSize);
   SetIndexBuffer(0,bBuffer1);
   SetIndexEmptyValue(0,0);
   SetIndexArrow(0,233);// 233
   
   SetIndexStyle(1,DRAW_ARROW);//LineSize);
   SetIndexBuffer(1,sBuffer1);
   SetIndexEmptyValue(1,0);
   SetIndexArrow(1,234);//234
  
  up1   = 0 ;
  down1 = 0 ;
 
//========================================================================================
     switch(TF)   {    case 1 : string TimeFrameStr60="Period_M1"; break;
                        case 5 : TimeFrameStr60="Period_M5"; break;
                       case 15 : TimeFrameStr60="Period_M15"; break;
                       case 30 : TimeFrameStr60="Period_M30"; break;
                       case 60 : TimeFrameStr60="Period_H1"; break;
                      case 240 : TimeFrameStr60="Period_H4"; break;
                     case 1440 : TimeFrameStr60="Period_D1"; break;
                    case 10080 : TimeFrameStr60="Period_W1"; break;
                    case 43200 : TimeFrameStr60="Period_MN1"; break;
                       default : TimeFrameStr60="Current Timeframe";
                   SetStepTF_Up();
                 }

//=======================================================================================  
        string  ThisName = "Rsi_55/45";// Rsi_246 ??? 
        string Text=ThisName;
        Text=Text+"  ("+TF;
        Text=Text+")";
        Text=Text+"( ";
        Text=Text+" "+DoubleToStr(RSIPeriod,0);
        Text=Text+")  ";
       IndicatorShortName(Text); 
         }
          return(0);
//+--------------------------------------------------------------------------------------+
int start()
  {
     static int last_bar = 0;
   if(last_bar==Bars) return (0);
   last_bar = Bars;
   int limit,y=0,counted_bars=IndicatorCounted();
   
   limit=Bars-counted_bars+TF/Period();
 
// limit=Bars-counted_bars;
   
   if(counted_bars>0) limit++; else if (limit>100) limit=CountBars;  
     SetIndexDrawBegin(0,Bars-CountBars);
     SetIndexDrawBegin(1,Bars-CountBars);

   for(int i=CountBars;i>0;i--)
          {  int p1;
             p1 = iBarShift( NULL, TF, Time[i], false );
            
                   bBuffer1[i] = EMPTY_VALUE; 
                   sBuffer1[i] = EMPTY_VALUE;
//=================================================================================================                   
//===================== RSI 55 / 45 =============================================================    

   double RSI1_rsi  = iRSI(NULL,TF,RSIPeriod,PRICE_CLOSE,p1);  
         if ((RSI1_rsi > 55)){ RSI1_up = 1; RSI1_dn = 0; }//  <<<<<<<<<< NB >>>>>>>>>>>>
         if ((RSI1_rsi < 45)){ RSI1_up = 0; RSI1_dn = 1; }// NB
         

//====================================================================================================
//======== ARROWS   ARROWS   ARROWS   ARROWS   ARROWS   ARROWS   ARROWS ==============================   
      
   if      ( up1 == 0   
             && ( RSI1_up  ) == 1      
           )
             {   bBuffer1[i] = Low[i]- Move_Arrow*Point;
                 if   ( Alarm_On && i == 1 && Bars>alertBar)
                      {     Alert(Symbol() + " M("+Period()+") - VM BUY");alertBar = Bars;
                      }
               up1   = 1;  down1 = 0;
            }    
//-------------------------------------------------------------------------------------------------         
  if     ( down1 ==0  
            && ( RSI1_dn  ) == 1     
         )
            {   sBuffer1[i] = High[i]+ Move_Arrow*Point;
                   if   ( Alarm_On && i == 1 && Bars>alertBar)
                        {    Alert(Symbol() + " M("+Period()+") - VM SELL");alertBar = Bars;
                        }
               down1 = 1;   up1   = 0;
           }
//===========cancel signal  and re enter in same direction===========================    
  
      if  (  up1 == 1
              &&  ( RSI1_up ) != 1  
          )
              { up1 = 0;   down1 = 0;
              }    
         
         
     if  (  down1 == 1 
          &&  ( RSI1_dn   ) != 1 
         )
              {  up1 = 0;   down1 = 0;
              }    
 //=====================================================================================
      } 
        return(0);
     }
 //========================step timeframe up TF60====================================== ++       
             void SetValues60(int p1)  {  TF = p1;        }                                   
        void SetStepTF_Up()     {  switch (Period() )                
           {  case PERIOD_M1  :  SetValues60(PERIOD_M1);    break;       
              case PERIOD_M5  :  SetValues60(PERIOD_M5);    break;         
              case PERIOD_M15 :  SetValues60(PERIOD_M15);   break;     
              case PERIOD_M30 :  SetValues60(PERIOD_M30);   break;            
              case PERIOD_H1  :  SetValues60(PERIOD_H1);    break;               
              case PERIOD_H4  :  SetValues60(PERIOD_H4);    break;                
              case PERIOD_D1  :  SetValues60(PERIOD_D1);    break;                
              case PERIOD_W1  :  SetValues60(PERIOD_W1);    break;             
              case PERIOD_MN1 :  SetValues60(PERIOD_MN1);   break;                   
           } }    
//================================================================================== ++  
 

